/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.spans.Spans;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.similarities.Similarity;

public class SpanScorer
extends Scorer {
    protected final Spans spans;
    protected final Similarity.SimScorer scorer;
    protected final NumericDocValues norms;
    private float freq;
    private int lastScoredDoc = -1;

    public SpanScorer(Spans spans, Similarity.SimScorer scorer, NumericDocValues norms) {
        this.spans = Objects.requireNonNull(spans);
        this.scorer = scorer;
        this.norms = norms;
    }

    public Spans getSpans() {
        return this.spans;
    }

    @Override
    public int docID() {
        return this.spans.docID();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.spans;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.spans.asTwoPhaseIterator();
    }

    protected float scoreCurrentDoc() throws IOException {
        assert (this.scorer != null) : String.valueOf(this.getClass()) + " has a null docScorer!";
        long norm = 1L;
        if (this.norms != null && this.norms.advanceExact(this.docID())) {
            norm = this.norms.longValue();
        }
        return this.scorer.score(this.freq, norm);
    }

    protected final void setFreqCurrentDoc() throws IOException {
        this.freq = 0.0f;
        this.spans.doStartCurrentDoc();
        assert (this.spans.startPosition() == -1) : "incorrect initial start position, " + String.valueOf(this.spans);
        assert (this.spans.endPosition() == -1) : "incorrect initial end position, " + String.valueOf(this.spans);
        int prevStartPos = -1;
        int prevEndPos = -1;
        int startPos = this.spans.nextStartPosition();
        assert (startPos != Integer.MAX_VALUE) : "initial startPos NO_MORE_POSITIONS, " + String.valueOf(this.spans);
        do {
            assert (startPos >= prevStartPos);
            int endPos = this.spans.endPosition();
            assert (endPos != Integer.MAX_VALUE);
            assert (startPos != prevStartPos || endPos >= prevEndPos) : "decreased endPos=" + endPos;
            if (this.scorer == null) {
                this.freq = 1.0f;
                return;
            }
            this.freq = (float)((double)this.freq + 1.0 / (1.0 + (double)this.spans.width()));
            this.spans.doCurrentSpans();
            prevStartPos = startPos;
            prevEndPos = endPos;
        } while ((startPos = this.spans.nextStartPosition()) != Integer.MAX_VALUE);
        assert (this.spans.startPosition() == Integer.MAX_VALUE) : "incorrect final start position, " + String.valueOf(this.spans);
        assert (this.spans.endPosition() == Integer.MAX_VALUE) : "incorrect final end position, " + String.valueOf(this.spans);
    }

    private void ensureFreq() throws IOException {
        int currentDoc = this.docID();
        if (this.lastScoredDoc != currentDoc) {
            this.setFreqCurrentDoc();
            this.lastScoredDoc = currentDoc;
        }
    }

    @Override
    public final float score() throws IOException {
        this.ensureFreq();
        return this.scoreCurrentDoc();
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }

    final float sloppyFreq() throws IOException {
        this.ensureFreq();
        return this.freq;
    }
}

