/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;

public final class IndexReaderFunctions {
    private IndexReaderFunctions() {
    }

    public static DoubleValuesSource docFreq(Term term) {
        return new IndexReaderDoubleValuesSource(r -> r.docFreq(term), "docFreq(" + term.toString() + ")");
    }

    public static DoubleValuesSource maxDoc() {
        return new IndexReaderDoubleValuesSource(IndexReader::maxDoc, "maxDoc()");
    }

    public static DoubleValuesSource numDocs() {
        return new IndexReaderDoubleValuesSource(IndexReader::numDocs, "numDocs()");
    }

    public static DoubleValuesSource numDeletedDocs() {
        return new IndexReaderDoubleValuesSource(IndexReader::numDeletedDocs, "numDeletedDocs()");
    }

    public static LongValuesSource sumTotalTermFreq(String field2) {
        return new SumTotalTermFreqValuesSource(field2);
    }

    public static DoubleValuesSource termFreq(Term term) {
        return new TermFreqDoubleValuesSource(term);
    }

    public static DoubleValuesSource totalTermFreq(Term term) {
        return new IndexReaderDoubleValuesSource(r -> r.totalTermFreq(term), "totalTermFreq(" + term.toString() + ")");
    }

    public static DoubleValuesSource sumDocFreq(String field2) {
        return new IndexReaderDoubleValuesSource(r -> r.getSumDocFreq(field2), "sumDocFreq(" + field2 + ")");
    }

    public static DoubleValuesSource docCount(String field2) {
        return new IndexReaderDoubleValuesSource(r -> r.getDocCount(field2), "docCount(" + field2 + ")");
    }

    private static class IndexReaderDoubleValuesSource
    extends DoubleValuesSource {
        private final ReaderFunction func;
        private final String description;

        private IndexReaderDoubleValuesSource(ReaderFunction func, String description) {
            this.func = func;
            this.description = description;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            throw new UnsupportedOperationException("IndexReaderFunction must be rewritten before use");
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new NoCacheConstantDoubleValuesSource(this.func.apply(searcher.getIndexReader()), this);
        }

        @Override
        public String toString() {
            return this.description;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexReaderDoubleValuesSource that = (IndexReaderDoubleValuesSource)o;
            return Objects.equals(this.description, that.description) && Objects.equals(this.func, that.func);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.description, this.func);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    @FunctionalInterface
    private static interface ReaderFunction {
        public double apply(IndexReader var1) throws IOException;
    }

    private static class SumTotalTermFreqValuesSource
    extends LongValuesSource {
        private final String field;

        private SumTotalTermFreqValuesSource(String field2) {
            this.field = field2;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            throw new UnsupportedOperationException("IndexReaderFunction must be rewritten before use");
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SumTotalTermFreqValuesSource that = (SumTotalTermFreqValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field);
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new NoCacheConstantLongValuesSource(searcher.getIndexReader().getSumTotalTermFreq(this.field), this);
        }

        @Override
        public String toString() {
            return "sumTotalTermFreq(" + this.field + ")";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class TermFreqDoubleValuesSource
    extends DoubleValuesSource {
        private final Term term;

        private TermFreqDoubleValuesSource(Term term) {
            this.term = term;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            Terms terms = Terms.getTerms(ctx.reader(), this.term.field());
            TermsEnum te = terms.iterator();
            if (!te.seekExact(this.term.bytes())) {
                return DoubleValues.EMPTY;
            }
            final PostingsEnum pe = te.postings(null);
            assert (pe != null);
            return new DoubleValues(this){

                @Override
                public double doubleValue() throws IOException {
                    return pe.freq();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    if (pe.docID() > doc) {
                        return false;
                    }
                    return pe.docID() == doc || pe.advance(doc) == doc;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }

        @Override
        public String toString() {
            return "termFreq(" + this.term.toString() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TermFreqDoubleValuesSource that = (TermFreqDoubleValuesSource)o;
            return Objects.equals(this.term, that.term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.term);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }

    private static class NoCacheConstantDoubleValuesSource
    extends DoubleValuesSource {
        final double value;
        final DoubleValuesSource parent;

        private NoCacheConstantDoubleValuesSource(double value, DoubleValuesSource parent) {
            this.value = value;
            this.parent = parent;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return value;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NoCacheConstantDoubleValuesSource)) {
                return false;
            }
            NoCacheConstantDoubleValuesSource that = (NoCacheConstantDoubleValuesSource)o;
            return Double.compare(that.value, this.value) == 0 && Objects.equals(this.parent, that.parent);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.parent);
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class NoCacheConstantLongValuesSource
    extends LongValuesSource {
        final long value;
        final LongValuesSource parent;

        private NoCacheConstantLongValuesSource(long value, LongValuesSource parent) {
            this.value = value;
            this.parent = parent;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return value;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher reader) throws IOException {
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NoCacheConstantLongValuesSource)) {
                return false;
            }
            NoCacheConstantLongValuesSource that = (NoCacheConstantLongValuesSource)o;
            return this.value == that.value && Objects.equals(this.parent, that.parent);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.parent);
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

