/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.VectorScorer;

public abstract class ByteVectorValues
extends KnnVectorValues {
    protected ByteVectorValues() {
    }

    public abstract byte[] vectorValue(int var1) throws IOException;

    @Override
    public abstract ByteVectorValues copy() throws IOException;

    public static void checkField(LeafReader in, String field2) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field2);
        if (fi != null && fi.hasVectorValues() && fi.getVectorEncoding() != VectorEncoding.BYTE) {
            throw new IllegalStateException("Unexpected vector encoding (" + String.valueOf((Object)fi.getVectorEncoding()) + ") for field " + field2 + "(expected=" + String.valueOf((Object)VectorEncoding.BYTE) + ")");
        }
    }

    public VectorScorer scorer(byte[] query) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorEncoding getEncoding() {
        return VectorEncoding.BYTE;
    }

    public static ByteVectorValues fromBytes(final List<byte[]> vectors, final int dim) {
        return new ByteVectorValues(){

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int dimension() {
                return dim;
            }

            @Override
            public byte[] vectorValue(int targetOrd) {
                return (byte[])vectors.get(targetOrd);
            }

            @Override
            public ByteVectorValues copy() {
                return this;
            }

            @Override
            public KnnVectorValues.DocIndexIterator iterator() {
                return this.createDenseIterator();
            }
        };
    }
}

