/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

final class LatLonDocValuesBoxQuery
extends Query {
    private final String field;
    private final int minLatitude;
    private final int maxLatitude;
    private final int minLongitude;
    private final int maxLongitude;
    private final boolean crossesDateline;

    LatLonDocValuesBoxQuery(String field2, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoUtils.checkLatitude(minLatitude);
        GeoUtils.checkLatitude(maxLatitude);
        GeoUtils.checkLongitude(minLongitude);
        GeoUtils.checkLongitude(maxLongitude);
        if (field2 == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field2;
        this.crossesDateline = minLongitude > maxLongitude;
        this.minLatitude = GeoEncodingUtils.encodeLatitudeCeil(minLatitude);
        this.maxLatitude = GeoEncodingUtils.encodeLatitude(maxLatitude);
        this.minLongitude = GeoEncodingUtils.encodeLongitudeCeil(minLongitude);
        this.maxLongitude = GeoEncodingUtils.encodeLongitude(maxLongitude);
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field2)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("box(minLat=").append(GeoEncodingUtils.decodeLatitude(this.minLatitude));
        sb.append(", maxLat=").append(GeoEncodingUtils.decodeLatitude(this.maxLatitude));
        sb.append(", minLon=").append(GeoEncodingUtils.decodeLongitude(this.minLongitude));
        sb.append(", maxLon=").append(GeoEncodingUtils.decodeLongitude(this.maxLongitude));
        return sb.append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesBoxQuery other = (LatLonDocValuesBoxQuery)obj;
        return this.field.equals(other.field) && this.crossesDateline == other.crossesDateline && this.minLatitude == other.minLatitude && this.maxLatitude == other.maxLatitude && this.minLongitude == other.minLongitude && this.maxLongitude == other.maxLongitude;
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Boolean.hashCode(this.crossesDateline);
        h = 31 * h + Integer.hashCode(this.minLatitude);
        h = 31 * h + Integer.hashCode(this.maxLatitude);
        h = 31 * h + Integer.hashCode(this.minLongitude);
        h = 31 * h + Integer.hashCode(this.maxLongitude);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesBoxQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            int lat = (int)(value >>> 32);
                            if (lat < LatLonDocValuesBoxQuery.this.minLatitude || lat > LatLonDocValuesBoxQuery.this.maxLatitude) continue;
                            int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                            if (LatLonDocValuesBoxQuery.this.crossesDateline ? lon > LatLonDocValuesBoxQuery.this.maxLongitude && lon < LatLonDocValuesBoxQuery.this.minLongitude : lon < LatLonDocValuesBoxQuery.this.minLongitude || lon > LatLonDocValuesBoxQuery.this.maxLongitude) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(boost, scoreMode, iterator);
                return new Weight.DefaultScorerSupplier(scorer);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, LatLonDocValuesBoxQuery.this.field);
            }
        };
    }
}

