/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class DoublePoint
extends Field {
    public static double nextUp(double d) {
        if (Double.doubleToLongBits(d) == Long.MIN_VALUE) {
            return 0.0;
        }
        return Math.nextUp(d);
    }

    public static double nextDown(double d) {
        if (Double.doubleToLongBits(d) == 0L) {
            return -0.0;
        }
        return Math.nextDown(d);
    }

    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 8);
        type.freeze();
        return type;
    }

    @Override
    public void setDoubleValue(double value) {
        this.setDoubleValues(value);
    }

    public void setDoubleValues(double ... point) {
        if (this.type.pointDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = DoublePoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from double to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes = (BytesRef)this.fieldsData;
        assert (bytes.length == 8);
        return DoublePoint.decodeDimension(bytes.bytes, bytes.offset);
    }

    public static BytesRef pack(double ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 8];
        for (int dim = 0; dim < point.length; ++dim) {
            DoublePoint.encodeDimension(point[dim], packed, dim * 8);
        }
        return new BytesRef(packed);
    }

    public DoublePoint(String name, double ... point) {
        super(name, DoublePoint.pack(point), (IndexableFieldType)DoublePoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDimensionCount(); ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(DoublePoint.decodeDimension(bytes.bytes, bytes.offset + dim * 8));
        }
        result.append('>');
        return result.toString();
    }

    public static void encodeDimension(double value, byte[] dest, int offset) {
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(value), dest, offset);
    }

    public static double decodeDimension(byte[] value, int offset) {
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(value, offset));
    }

    public static Query newExactQuery(String field2, double value) {
        return DoublePoint.newRangeQuery(field2, value, value);
    }

    public static Query newRangeQuery(String field2, double lowerValue, double upperValue) {
        return DoublePoint.newRangeQuery(field2, new double[]{lowerValue}, new double[]{upperValue});
    }

    public static Query newRangeQuery(String field2, double[] lowerValue, double[] upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        return new PointRangeQuery(field2, DoublePoint.pack((double[])lowerValue).bytes, DoublePoint.pack((double[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Double.toString(DoublePoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, double ... values) {
        final double[] sortedValues = (double[])values.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[8]);
        return new PointInSetQuery(field2, 1, 8, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                DoublePoint.encodeDimension(sortedValues[this.upto], encoded.bytes, 0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 8);
                return Double.toString(DoublePoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, Collection<Double> values) {
        Double[] boxed = values.toArray(new Double[0]);
        double[] unboxed = new double[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            unboxed[i] = boxed[i];
        }
        return DoublePoint.newSetQuery(field2, unboxed);
    }
}

