/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morph;

import org.apache.lucene.analysis.morph.TokenType;

public abstract class Token {
    protected final char[] surfaceForm;
    protected final int offset;
    protected final int length;
    protected final int startOffset;
    protected final int endOffset;
    protected int posIncr = 1;
    protected int posLen = 1;
    protected final TokenType type;

    protected Token(char[] surfaceForm, int offset, int length, int startOffset, int endOffset, TokenType type) {
        this.surfaceForm = surfaceForm;
        this.offset = offset;
        this.length = length;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type;
    }

    public char[] getSurfaceForm() {
        return this.surfaceForm;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getSurfaceFormString() {
        return new String(this.surfaceForm, this.offset, this.length);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setPositionIncrement(int posIncr) {
        this.posIncr = posIncr;
    }

    public int getPositionIncrement() {
        return this.posIncr;
    }

    public void setPositionLength(int posLen) {
        this.posLen = posLen;
    }

    public int getPositionLength() {
        return this.posLen;
    }

    public TokenType getType() {
        return this.type;
    }
}

