/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morph;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;

public abstract class ConnectionCosts {
    public static final String FILENAME_SUFFIX = ".dat";
    private final ByteBuffer buffer;
    private final int forwardSize;

    protected ConnectionCosts(IOSupplier<InputStream> connectionCostResource, String connectionCostsCodecHeader, int dictCodecVersion) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(connectionCostResource.get());){
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, connectionCostsCodecHeader, dictCodecVersion, dictCodecVersion);
            this.forwardSize = in.readVInt();
            int backwardSize = in.readVInt();
            int size = this.forwardSize * backwardSize;
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size * 2);
            int accum2 = 0;
            for (int j = 0; j < backwardSize; ++j) {
                for (int i = 0; i < this.forwardSize; ++i) {
                    tmpBuffer.putShort((short)(accum2 += in.readZInt()));
                }
            }
            this.buffer = tmpBuffer.asReadOnlyBuffer();
        }
    }

    public int get(int forwardId, int backwardId) {
        int offset = (backwardId * this.forwardSize + forwardId) * 2;
        return this.buffer.getShort(offset);
    }
}

