/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.hunspell.FragmentChecker;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.RepEntry;
import org.apache.lucene.analysis.hunspell.Suggestion;
import org.apache.lucene.analysis.hunspell.WordCase;

class ModifyingSuggester {
    private static final int MAX_CHAR_DISTANCE = 4;
    private final LinkedHashSet<Suggestion> result;
    private final String misspelled;
    private final WordCase wordCase;
    private final FragmentChecker fragmentChecker;
    private final boolean proceedPastRep;
    private final char[] tryChars;
    private final Hunspell speller;
    private final Set<String> tried = new HashSet<String>();

    ModifyingSuggester(Hunspell speller, LinkedHashSet<Suggestion> result, String misspelled, WordCase wordCase, FragmentChecker checker, boolean proceedPastRep) {
        this.speller = speller;
        this.tryChars = speller.dictionary.tryChars.toCharArray();
        this.result = result;
        this.misspelled = misspelled;
        this.wordCase = wordCase;
        this.fragmentChecker = checker;
        this.proceedPastRep = proceedPastRep;
    }

    boolean suggest() {
        String low;
        String string2 = low = this.wordCase != WordCase.LOWER ? this.speller.dictionary.toLowerCase(this.misspelled) : this.misspelled;
        if (this.wordCase == WordCase.UPPER || this.wordCase == WordCase.MIXED) {
            this.trySuggestion(low);
        }
        boolean hasGoodSuggestions = this.tryVariationsOf(this.misspelled);
        if (this.wordCase == WordCase.TITLE) {
            hasGoodSuggestions |= this.tryVariationsOf(low);
        } else if (this.wordCase == WordCase.UPPER) {
            hasGoodSuggestions |= this.tryVariationsOf(low);
            hasGoodSuggestions |= this.tryVariationsOf(this.speller.dictionary.toTitleCase(this.misspelled));
        } else if (this.wordCase == WordCase.MIXED) {
            char first;
            boolean capitalized;
            String afterDot;
            int dot = this.misspelled.indexOf(46);
            if (dot > 0 && dot < this.misspelled.length() - 1 && WordCase.caseOf(afterDot = this.misspelled.substring(dot + 1)) == WordCase.TITLE) {
                this.result.add(this.createSuggestion(this.misspelled.substring(0, dot + 1) + " " + afterDot));
            }
            if (capitalized = Character.isUpperCase(first = this.misspelled.charAt(0))) {
                hasGoodSuggestions |= this.tryVariationsOf(this.speller.dictionary.caseFold(first) + this.misspelled.substring(1));
            }
            hasGoodSuggestions |= this.tryVariationsOf(low);
            if (capitalized) {
                hasGoodSuggestions |= this.tryVariationsOf(this.speller.dictionary.toTitleCase(low));
            }
            ArrayList<Suggestion> reordered = new ArrayList<Suggestion>();
            for (Suggestion candidate : this.result) {
                Suggestion changed = this.capitalizeAfterSpace(candidate.raw);
                if (changed == null) {
                    reordered.add(candidate);
                    continue;
                }
                reordered.add(0, changed);
            }
            this.result.clear();
            this.result.addAll(reordered);
        }
        return hasGoodSuggestions;
    }

    private Suggestion createSuggestion(String candidate) {
        return new Suggestion(candidate, this.misspelled, this.wordCase, this.speller);
    }

    private Suggestion capitalizeAfterSpace(String candidate) {
        int space = candidate.indexOf(32);
        int tail = candidate.length() - space - 1;
        if (space > 0 && !this.misspelled.regionMatches(this.misspelled.length() - tail, candidate, space + 1, tail)) {
            return this.createSuggestion(candidate.substring(0, space + 1) + Character.toUpperCase(candidate.charAt(space + 1)) + candidate.substring(space + 2));
        }
        return null;
    }

    private boolean tryVariationsOf(String word) {
        boolean hasGoodSuggestions = this.trySuggestion(word.toUpperCase(Locale.ROOT));
        GradedSuggestions repResult = this.tryRep(word);
        if (repResult == GradedSuggestions.Best && !this.proceedPastRep) {
            return true;
        }
        hasGoodSuggestions |= repResult != GradedSuggestions.None;
        if (!this.speller.dictionary.mapTable.isEmpty()) {
            this.enumerateMapReplacements(word, "", 0);
        }
        this.trySwappingChars(word);
        this.tryLongSwap(word);
        this.tryNeighborKeys(word);
        this.tryRemovingChar(word);
        this.tryAddingChar(word);
        this.tryMovingChar(word);
        this.tryReplacingChar(word);
        this.tryTwoDuplicateChars(word);
        List<Suggestion> goodSplit = this.checkDictionaryForSplitSuggestions(word);
        if (!goodSplit.isEmpty()) {
            ArrayList<Suggestion> copy = new ArrayList<Suggestion>(this.result);
            this.result.clear();
            this.result.addAll(goodSplit);
            if (hasGoodSuggestions) {
                this.result.addAll(copy);
            }
            hasGoodSuggestions = true;
        }
        if (!hasGoodSuggestions && this.speller.dictionary.enableSplitSuggestions) {
            this.trySplitting(word);
        }
        return hasGoodSuggestions;
    }

    private GradedSuggestions tryRep(String word) {
        boolean hasBest = false;
        int before = this.result.size();
        for (RepEntry entry : this.speller.dictionary.repTable) {
            for (String candidate : entry.substitute(word)) {
                if (this.trySuggestion(candidate = candidate.trim())) {
                    hasBest = true;
                    continue;
                }
                if (!candidate.contains(" ") || !Arrays.stream(candidate.split(" ")).allMatch(this::checkSimpleWord)) continue;
                this.result.add(this.createSuggestion(candidate));
            }
        }
        if (hasBest) {
            return GradedSuggestions.Best;
        }
        return this.result.size() > before ? GradedSuggestions.Normal : GradedSuggestions.None;
    }

    private void enumerateMapReplacements(String word, String accumulated, int offset) {
        if (offset == word.length()) {
            this.trySuggestion(accumulated);
            return;
        }
        int length = accumulated.length();
        for (List<String> entries : this.speller.dictionary.mapTable) {
            for (String entry : entries) {
                if (!word.regionMatches(offset, entry, 0, entry.length())) continue;
                for (String replacement : entries) {
                    int end;
                    String next;
                    if (entry.equals(replacement) || this.fragmentChecker.hasImpossibleFragmentAround(next = accumulated + replacement, length, end = length + replacement.length())) continue;
                    this.enumerateMapReplacements(word, next, offset + entry.length());
                }
            }
        }
        String next = accumulated + word.charAt(offset);
        if (!this.fragmentChecker.hasImpossibleFragmentAround(next, length, length + 1)) {
            this.enumerateMapReplacements(word, next, offset + 1);
        }
    }

    private boolean checkSimpleWord(String part) {
        return Boolean.TRUE.equals(this.speller.checkSimpleWord(part.toCharArray(), part.length(), null));
    }

    private void trySwappingChars(String word) {
        int length = word.length();
        for (int i = 0; i < length - 1; ++i) {
            char c1 = word.charAt(i);
            char c2 = word.charAt(i + 1);
            this.trySuggestion(word.substring(0, i) + c2 + c1 + word.substring(i + 2));
        }
        if (length == 4 || length == 5) {
            this.tryDoubleSwapForShortWords(word, length);
        }
    }

    private void tryDoubleSwapForShortWords(String word, int length) {
        char[] candidate = word.toCharArray();
        candidate[0] = word.charAt(1);
        candidate[1] = word.charAt(0);
        candidate[length - 1] = word.charAt(length - 2);
        candidate[length - 2] = word.charAt(length - 1);
        this.trySuggestion(new String(candidate));
        if (candidate.length == 5) {
            candidate[0] = word.charAt(0);
            candidate[1] = word.charAt(2);
            candidate[2] = word.charAt(1);
            this.trySuggestion(new String(candidate));
        }
    }

    private void tryNeighborKeys(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            char up = Character.toUpperCase(c);
            if (up != c) {
                this.trySuggestion(word.substring(0, i) + up + word.substring(i + 1));
            }
            for (String group : this.speller.dictionary.neighborKeyGroups) {
                if (group.indexOf(c) < 0) continue;
                for (int j = 0; j < group.length(); ++j) {
                    if (group.charAt(j) == c) continue;
                    this.tryModifiedSuggestions(i, word.substring(0, i) + group.charAt(j) + word.substring(i + 1));
                }
            }
        }
    }

    private void tryModifiedSuggestions(int modOffset, String candidate) {
        if (!this.fragmentChecker.hasImpossibleFragmentAround(candidate, modOffset, modOffset + 1)) {
            this.trySuggestion(candidate);
        }
    }

    private void tryLongSwap(String word) {
        for (int i = 0; i < word.length(); ++i) {
            for (int j = i + 2; j < word.length() && j <= i + 4; ++j) {
                char c1 = word.charAt(i);
                char c2 = word.charAt(j);
                String prefix = word.substring(0, i);
                String suffix = word.substring(j + 1);
                this.trySuggestion(prefix + c2 + word.substring(i + 1, j) + c1 + suffix);
            }
        }
    }

    private void tryRemovingChar(String word) {
        if (word.length() == 1) {
            return;
        }
        for (int i = 0; i < word.length(); ++i) {
            this.trySuggestion(word.substring(0, i) + word.substring(i + 1));
        }
    }

    private void tryAddingChar(String word) {
        for (int i = 0; i <= word.length(); ++i) {
            String prefix = word.substring(0, i);
            String suffix = word.substring(i);
            for (char toInsert : this.tryChars) {
                this.tryModifiedSuggestions(prefix.length(), prefix + toInsert + suffix);
            }
        }
    }

    private void tryMovingChar(String word) {
        for (int i = 0; i < word.length(); ++i) {
            String prefix = word.substring(0, i);
            for (int j = i + 2; j < word.length() && j <= i + 4; ++j) {
                this.trySuggestion(prefix + word.substring(i + 1, j) + word.charAt(i) + word.substring(j));
                this.trySuggestion(prefix + word.charAt(j) + word.substring(i, j) + word.substring(j + 1));
            }
            if (i >= word.length() - 1) continue;
            this.trySuggestion(prefix + word.substring(i + 1) + word.charAt(i));
        }
    }

    private void tryReplacingChar(String word) {
        for (int i = 0; i < word.length(); ++i) {
            String prefix = word.substring(0, i);
            String suffix = word.substring(i + 1);
            for (char toInsert : this.tryChars) {
                if (toInsert == word.charAt(i)) continue;
                this.tryModifiedSuggestions(prefix.length(), prefix + toInsert + suffix);
            }
        }
    }

    private void tryTwoDuplicateChars(String word) {
        int dupLen = 0;
        for (int i = 2; i < word.length(); ++i) {
            if (word.charAt(i) == word.charAt(i - 2)) {
                if (++dupLen != 3 && (dupLen != 2 || i < 4)) continue;
                this.trySuggestion(word.substring(0, i - 1) + word.substring(i + 1));
                dupLen = 0;
                continue;
            }
            dupLen = 0;
        }
    }

    private List<Suggestion> checkDictionaryForSplitSuggestions(String word) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (int i = 1; i < word.length() - 1; ++i) {
            String dashed;
            String w2;
            String w1 = word.substring(0, i);
            String spaced = w1 + " " + (w2 = word.substring(i));
            if (this.speller.checkWord(spaced)) {
                result.add(this.createSuggestion(spaced));
            }
            if (!this.shouldSplitByDash() || !this.speller.checkWord(dashed = w1 + "-" + w2)) continue;
            result.add(this.createSuggestion(dashed));
        }
        return result;
    }

    private void trySplitting(String word) {
        for (int i = 1; i < word.length(); ++i) {
            String w1 = word.substring(0, i);
            String w2 = word.substring(i);
            if (!this.checkSimpleWord(w1) || !this.checkSimpleWord(w2)) continue;
            this.result.add(this.createSuggestion(w1 + " " + w2));
            if (w1.length() <= 1 || w2.length() <= 1 || !this.shouldSplitByDash()) continue;
            this.result.add(this.createSuggestion(w1 + "-" + w2));
        }
    }

    private boolean shouldSplitByDash() {
        return this.speller.dictionary.tryChars.contains("-") || this.speller.dictionary.tryChars.contains("a");
    }

    private boolean trySuggestion(String candidate) {
        return this.tried.add(candidate) && this.speller.checkWord(candidate) && this.result.add(this.createSuggestion(candidate));
    }

    private static enum GradedSuggestions {
        None,
        Normal,
        Best;

    }
}

