/*
 * Decompiled with CFR 0.152.
 */
package esc.normalization;

import java.io.Serializable;
import java.text.Normalizer;
import java.util.Locale;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class TextNormalizer$
implements Serializable {
    public static final TextNormalizer$ MODULE$ = new TextNormalizer$();

    private TextNormalizer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TextNormalizer$.class);
    }

    public String normalize(String text) {
        Regex regexPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^\\p{L}0-9 \\-]"));
        String mutNormString = Normalizer.normalize(text, Normalizer.Form.NFKD).toLowerCase(Locale.ENGLISH);
        mutNormString = mutNormString.replace("\u00f8", "o");
        mutNormString = mutNormString.replace("\u0153", "oe");
        mutNormString = mutNormString.replace("\u00df", "ss");
        mutNormString = mutNormString.replace("\u00e6", "ae");
        mutNormString = mutNormString.replace("\u00a2", "c");
        mutNormString = mutNormString.replace("\u0259", "a");
        mutNormString = mutNormString.replace("\u0131", "i");
        mutNormString = mutNormString.replace("\u02bfbd", "abd");
        mutNormString = mutNormString.replace("\u02bfly", "ali");
        mutNormString = mutNormString.replace("&", "plus");
        mutNormString = mutNormString.replace("+", "plus");
        mutNormString = mutNormString.replace("@", "at");
        mutNormString = mutNormString.replace("\n", " ");
        mutNormString = mutNormString.replaceAll("- -", "-");
        mutNormString = mutNormString.replaceAll(" +", " ");
        mutNormString = mutNormString.replaceAll("-+", "-");
        mutNormString = mutNormString.replaceAll(" *- *", "-");
        mutNormString = mutNormString.replaceAll("^-", "");
        mutNormString = mutNormString.replaceAll("-$", "");
        mutNormString = mutNormString.replaceAll("^von *der ", "vonder ");
        mutNormString = mutNormString.replaceAll(" von *der ", " vonder ");
        mutNormString = mutNormString.replaceAll(" von *der$", "vonder");
        mutNormString = mutNormString.replaceAll("^von *de ", "vonde ");
        mutNormString = mutNormString.replaceAll(" von *de ", " vonde ");
        mutNormString = mutNormString.replaceAll(" von *de$", " vonde");
        mutNormString = mutNormString.replaceAll("^van *der ", "vander ");
        mutNormString = mutNormString.replaceAll(" van *der ", " vander ");
        mutNormString = mutNormString.replaceAll(" van *der$", "vander");
        mutNormString = mutNormString.replaceAll("^van *de ", "vande ");
        mutNormString = mutNormString.replaceAll(" van *de ", " vande ");
        mutNormString = mutNormString.replaceAll(" van *de$", " vande");
        mutNormString = mutNormString.replaceAll("^an *der ", "ander ");
        mutNormString = mutNormString.replaceAll(" an *der ", " ander ");
        mutNormString = mutNormString.replaceAll(" an *der$", " ander");
        mutNormString = mutNormString.replaceAll("^de *la ", "dela ");
        mutNormString = mutNormString.replaceAll(" de *la ", " dela ");
        mutNormString = mutNormString.replaceAll(" de *la$", "dela");
        mutNormString = regexPattern.replaceAllIn((CharSequence)mutNormString, "");
        return mutNormString.trim();
    }

    public String normalizeWithLegalForm(String text) {
        String mutNormString = this.normalize(text);
        mutNormString = mutNormString.replace("gmbh *and *co *kg", "gmbh_and_co_kg");
        mutNormString = mutNormString.replace("gmbh *and *co *ohg", "gmbh_and_co_ohg");
        mutNormString = mutNormString.replace("gmbh *and *co *kgaa", "gmbh_and_co_kgaa");
        mutNormString = mutNormString.replace("ohg *mbh", "ohg_mbh");
        mutNormString = mutNormString.replace("ag *and *co *ohg", "ag_and_co_ohg");
        mutNormString = mutNormString.replace("ag *and *co *kgaa", "ag_and_co_kgaa");
        mutNormString = mutNormString.replace("ag *and *co *kg", "ag_and_co_kg");
        mutNormString = mutNormString.replace("stiftung *and *co *kgaa", "stiftung_and_co_gkaa");
        mutNormString = mutNormString.replace("co-operative", "cooperative");
        mutNormString = mutNormString.replace("societe *cooperative", "societe_cooperative");
        mutNormString = mutNormString.replace("societa *cooperativa", "societa_cooperativa");
        mutNormString = mutNormString.replace("company *limited", "lc");
        mutNormString = mutNormString.replace("company *ltd", "lc");
        mutNormString = mutNormString.replace("limited *company", "lc");
        mutNormString = mutNormString.replace("public *limited *company", "plc");
        mutNormString = mutNormString.replace("company *corp", "corp");
        mutNormString = mutNormString.replace("unlimited *company", "uc");
        mutNormString = mutNormString.replace("incorporated company", "inc");
        mutNormString = mutNormString.replace("( *a o)$", "ao");
        return mutNormString;
    }

    public String normalizeNameElement(String nameElement) {
        String mutNormNameElement = nameElement;
        mutNormNameElement = mutNormNameElement.replaceAll("witsch$", "vich");
        mutNormNameElement = mutNormNameElement.replaceAll("wjtsch$", "vich");
        mutNormNameElement = mutNormNameElement.replaceAll("witsj$", "vich");
        mutNormNameElement = mutNormNameElement.replaceAll("wicz$", "vich");
        mutNormNameElement = mutNormNameElement.replaceAll("vych$", "vich");
        mutNormNameElement = mutNormNameElement.replaceAll("vitch$", "vich");
        mutNormNameElement = mutNormNameElement.replaceAll("off$", "ov");
        mutNormNameElement = mutNormNameElement.replaceAll("eff$", "ev");
        mutNormNameElement = mutNormNameElement.replaceAll("ow$", "ov");
        mutNormNameElement = mutNormNameElement.replaceAll("owna$", "ovna");
        mutNormNameElement = mutNormNameElement.replaceAll("ew$", "ev");
        mutNormNameElement = mutNormNameElement.replaceAll("jew$", "ev");
        mutNormNameElement = mutNormNameElement.replaceAll("schew$", "chev");
        mutNormNameElement = mutNormNameElement.replaceAll("czuk$", "chuk");
        mutNormNameElement = mutNormNameElement.replaceAll("vets$", "wez");
        mutNormNameElement = mutNormNameElement.replaceAll("sky$", "ski");
        mutNormNameElement = mutNormNameElement.replaceAll("skij$", "ski");
        mutNormNameElement = mutNormNameElement.replaceAll("skii$", "ski");
        mutNormNameElement = mutNormNameElement.replaceAll("yuk$", "uk");
        mutNormNameElement = mutNormNameElement.replaceAll("juk$", "uk");
        mutNormNameElement = mutNormNameElement.replaceAll("-tao", "tao");
        return mutNormNameElement;
    }
}

