/*
 * Decompiled with CFR 0.152.
 */
package esc.normalization;

import com.ibm.icu.text.Transliterator;
import java.io.Serializable;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Transliterator$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Transliterator$.class.getDeclaredField("scriptToTransliterator$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Transliterator$.class.getDeclaredField("defaultTransliterator$lzy1"));
    private static String RULE_SET;
    private volatile Object defaultTransliterator$lzy1;
    private volatile Object scriptToTransliterator$lzy1;
    public static final Transliterator$ MODULE$;

    private Transliterator$() {
    }

    static {
        MODULE$ = new Transliterator$();
        RULE_SET = "Any-Latin; NFD; Latin-ASCII";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Transliterator$.class);
    }

    private Transliterator defaultTransliterator() {
        Object object = this.defaultTransliterator$lzy1;
        if (object instanceof Transliterator) {
            return (Transliterator)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Transliterator)this.defaultTransliterator$lzyINIT1();
    }

    private Object defaultTransliterator$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.defaultTransliterator$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Transliterator transliterator = null;
                    try {
                        transliterator = Transliterator.getInstance(RULE_SET);
                        object2 = transliterator == null ? LazyVals$NullValue$.MODULE$ : transliterator;
                        RULE_SET = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultTransliterator$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return transliterator;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Map<String, Transliterator> scriptToTransliterator() {
        Object object = this.scriptToTransliterator$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.scriptToTransliterator$lzyINIT1();
    }

    private Object scriptToTransliterator$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.scriptToTransliterator$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        Tuple2[] tuple2Array = new Tuple2[7];
                        String string2 = Predef$.MODULE$.ArrowAssoc("arabic");
                        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, Transliterator.getInstance("Arabic-Latin; NFD; Latin-ASCII"));
                        String string3 = Predef$.MODULE$.ArrowAssoc("cyrillic");
                        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, Transliterator.getInstance("Cyrillic-Latin; NFD; Latin-ASCII"));
                        String string4 = Predef$.MODULE$.ArrowAssoc("japanese");
                        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, Transliterator.getInstance("Kana-Latin; NFD; Latin-ASCII"));
                        String string5 = Predef$.MODULE$.ArrowAssoc("chinese");
                        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, Transliterator.getInstance("Han-Latin; NFD; Latin-ASCII"));
                        String string6 = Predef$.MODULE$.ArrowAssoc("greek");
                        tuple2Array[4] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string6, Transliterator.getInstance("Greek-Latin; NFD; Latin-ASCII"));
                        String string7 = Predef$.MODULE$.ArrowAssoc("korean");
                        tuple2Array[5] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string7, Transliterator.getInstance("Hangul-Latin; NFD; Latin-ASCII"));
                        String string8 = Predef$.MODULE$.ArrowAssoc("default");
                        tuple2Array[6] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string8, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        map = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
                        object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scriptToTransliterator$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.scriptToTransliterator$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String detectScript(String s) {
        Regex arabic = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsArabic}"));
        Regex cyrillic = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsCyrillic}"));
        Regex hiragana = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHiragana}"));
        Regex katakana = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsKatakana}"));
        Regex han = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHan}"));
        Regex greek = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsGreek}"));
        Regex hangul = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHangul}"));
        if (arabic.findFirstIn(s).isDefined()) {
            return "arabic";
        }
        if (cyrillic.findFirstIn(s).isDefined()) {
            return "cyrillic";
        }
        if (hiragana.findFirstIn(s).isDefined() || katakana.findFirstIn(s).isDefined()) {
            return "japanese";
        }
        if (han.findFirstIn(s).isDefined()) {
            return "chinese";
        }
        if (greek.findFirstIn(s).isDefined()) {
            return "greek";
        }
        if (hangul.findFirstIn(s).isDefined()) {
            return "korean";
        }
        return "default";
    }

    public String transToLatin(String text) {
        Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(this.detectScript(text), Transliterator$::$anonfun$1);
        return translator.transliterate(text);
    }

    private static final Transliterator $anonfun$1() {
        return MODULE$.defaultTransliterator();
    }
}

