/*
 * Decompiled with CFR 0.152.
 */
package esc.normalization;

import esc.commons.NormalizedAddress;
import esc.configuration.SimilarityConfig;
import esc.normalization.AddressNormalizer$;
import esc.normalization.TextNormalizer$;
import esc.utils.Countries$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public class AddressNormalizer {
    private final SimilarityConfig similarityConfig;
    private final List<String> stopWords;
    private final List<String> hitWords;

    public static SimilarityConfig $lessinit$greater$default$1() {
        return AddressNormalizer$.MODULE$.$lessinit$greater$default$1();
    }

    public static List<String> $lessinit$greater$default$2() {
        return AddressNormalizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<String> $lessinit$greater$default$3() {
        return AddressNormalizer$.MODULE$.$lessinit$greater$default$3();
    }

    public AddressNormalizer(SimilarityConfig similarityConfig, List<String> stopWords, List<String> hitWords) {
        this.similarityConfig = similarityConfig;
        this.stopWords = stopWords;
        this.hitWords = hitWords;
    }

    public SimilarityConfig similarityConfig() {
        return this.similarityConfig;
    }

    public List<String> stopWords() {
        return this.stopWords;
    }

    public List<String> hitWords() {
        return this.hitWords;
    }

    public NormalizedAddress normalizeAddress(String address) {
        Predef$.MODULE$.require(address.length() > 1);
        Predef$.MODULE$.require(this.stopWords() != null);
        Predef$.MODULE$.require(this.hitWords() != null);
        ListBuffer countries = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps(TextNormalizer$.MODULE$.normalize(address).split(" "));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1<String, Boolean> & Serializable)e -> {
            boolean filter = true;
            Tuple4<Boolean, Boolean, Tuple2<Object, String>, Boolean> tuple4 = Tuple4$.MODULE$.apply(BoxesRunTime.boxToBoolean(this.similarityConfig().checkCountyForAdressSearch()), BoxesRunTime.boxToBoolean(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)e)) > 3), Countries$.MODULE$.toIsoCountry((String)e), BoxesRunTime.boxToBoolean(this.stopWords().contains(e)));
            if (tuple4 != null) {
                Tuple2<Object, String> tuple2 = tuple4._3();
                if (BoxesRunTime.unboxToBoolean(tuple4._1()) && BoxesRunTime.unboxToBoolean(tuple4._2()) && tuple2 != null && BoxesRunTime.unboxToBoolean(tuple2._1())) {
                    String c = tuple2._2();
                    countries.$plus$eq(c);
                    return false;
                }
                if (tuple2 != null && BoxesRunTime.unboxToBoolean(tuple4._4())) {
                    return false;
                }
            }
            Tuple4<Boolean, Boolean, Tuple2<Object, String>, Boolean> tuple42 = tuple4;
            return true;
        }));
        String[] normAddress = (String[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1<String, List> & Serializable)e -> {
            boolean bl = this.hitWords().contains(e);
            if (bl) {
                return (List)package$.MODULE$.List().fill(this.similarityConfig().numberOfHitsForAddressSearchHit(), () -> AddressNormalizer.$anonfun$2$$anonfun$1(e));
            }
            if (!bl) {
                return (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)e), Nil$.MODULE$));
            }
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }, ClassTag$.MODULE$.apply(String.class));
        return new NormalizedAddress(address, Predef$.MODULE$.wrapRefArray(normAddress).toList(), countries.toList());
    }

    private static final String $anonfun$2$$anonfun$1(String e$1) {
        return e$1;
    }
}

