/*
 * Decompiled with CFR 0.152.
 */
package esc.index;

import esc.commons.Constants$;
import esc.commons.IndexOrganisation;
import esc.commons.IndexPerson;
import esc.commons.NormalizedDate;
import esc.commons.NormalizedName;
import esc.configuration.SimilarityConfig;
import esc.index.Indexer$;
import esc.normalization.DateNormalizer$;
import esc.normalization.NameNormalizer;
import esc.normalization.TextNormalizer$;
import esc.similarity.nameElementSimilarityDb$;
import esc.utils.Countries$;
import esc.utils.Persistence$;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public class Indexer {
    private final IndexWriter indexWriter;
    private final SimilarityConfig similarityConfig;
    private final NameNormalizer nameNormalizer;

    public static SimilarityConfig $lessinit$greater$default$2() {
        return Indexer$.MODULE$.$lessinit$greater$default$2();
    }

    public Indexer(IndexWriter indexWriter, SimilarityConfig similarityConfig) {
        this.indexWriter = indexWriter;
        this.similarityConfig = similarityConfig;
        this.nameNormalizer = new NameNormalizer(similarityConfig);
    }

    public IndexWriter indexWriter() {
        return this.indexWriter;
    }

    public SimilarityConfig similarityConfig() {
        return this.similarityConfig;
    }

    public boolean close() {
        this.indexWriter().close();
        return true;
    }

    public boolean commit() {
        this.indexWriter().commit();
        return true;
    }

    public boolean addPerson(IndexPerson person) {
        NormalizedName normalizedName = this.nameNormalizer.normalizePersonName(person.fullName());
        this.indexWriter().addDocument(this.createDocument(person.id(), person.externalId(), person.fullName(), normalizedName, Persistence$.MODULE$.toCompactJson(normalizedName.normNames()), Constants$.MODULE$.IndexPersonNameTypeCode(), person.datesOfBirth(), (List<String>)((List)person.countries().map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                if (bl) {
                    String country = tuple2._2();
                    return country;
                }
                if (!bl) {
                    return "";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, Boolean> & Serializable)c -> {
            String string2 = c;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }), person.label()));
        return true;
    }

    public boolean addOrganisation(IndexOrganisation organisation) {
        NormalizedName normalizedName = this.nameNormalizer.normalizeOrganisationName(organisation.fullName());
        this.indexWriter().addDocument(this.createDocument(organisation.id(), organisation.externalId(), organisation.fullName(), normalizedName, Persistence$.MODULE$.toCompactJson(normalizedName.normNames()), Constants$.MODULE$.IndexOrganisationNameTypeCode(), organisation.datesOfFounding(), (List<String>)((List)organisation.countries().map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                if (bl) {
                    String country = tuple2._2();
                    return country;
                }
                if (!bl) {
                    return "";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, Boolean> & Serializable)c -> {
            String string2 = c;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }), organisation.label()));
        return true;
    }

    public boolean updatePerson(IndexPerson person) {
        NormalizedName normalizedName = this.nameNormalizer.normalizePersonName(person.fullName());
        this.indexWriter().updateDocument(new Term("id", person.id()), this.createDocument(person.id(), person.externalId(), person.fullName(), normalizedName, Persistence$.MODULE$.toCompactJson(normalizedName.normNames()), Constants$.MODULE$.IndexPersonNameTypeCode(), person.datesOfBirth(), (List<String>)((List)person.countries().map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                if (bl) {
                    String country = tuple2._2();
                    return country;
                }
                if (!bl) {
                    return "";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, Boolean> & Serializable)c -> {
            String string2 = c;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }), person.label()));
        return true;
    }

    public boolean updateOrganisation(IndexOrganisation organisation) {
        NormalizedName normalizedName = this.nameNormalizer.normalizeOrganisationName(organisation.fullName());
        this.indexWriter().updateDocument(new Term("id", organisation.id()), this.createDocument(organisation.id(), organisation.externalId(), organisation.fullName(), normalizedName, Persistence$.MODULE$.toCompactJson(normalizedName.normNames()), Constants$.MODULE$.IndexOrganisationNameTypeCode(), organisation.datesOfFounding(), (List<String>)((List)organisation.countries().map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                if (bl) {
                    String country = tuple2._2();
                    return country;
                }
                if (!bl) {
                    return "";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, Boolean> & Serializable)c -> {
            String string2 = c;
            String string3 = "";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }), organisation.label()));
        return true;
    }

    public boolean removePerson(String personId) {
        this.indexWriter().deleteDocuments(new Term("id", personId));
        return true;
    }

    public boolean removeOrganisation(String organisationId) {
        this.indexWriter().deleteDocuments(new Term("id", organisationId));
        return true;
    }

    private Document createDocument(String id, String externalId, String fullName, NormalizedName normalizedName, String jsonName, String nameType, List<String> dates, List<String> countries, String label) {
        Document doc = new Document();
        doc.add(new StringField("id", id, Field.Store.YES));
        doc.add(new StringField("exid", externalId, Field.Store.YES));
        doc.add(new StringField("name", fullName, Field.Store.YES));
        doc.add(new TextField("ir", fullName, Field.Store.NO));
        ObjectRef<Object> nameDoc = ObjectRef.create(ListBuffer$.MODULE$.empty());
        normalizedName.normNames().foreach(variant -> variant.foreach((Function1<Tuple3, Object> & Serializable)element -> {
            byte by = BoxesRunTime.unboxToByte(element._3());
            if (1 == by) {
                Tuple2<Object, Object> tuple2 = this.nameNormalizer.persNameElementReducedWeight((String)element._1(), 1.0);
                if (tuple2 != null) {
                    boolean bl = tuple2._2$mcZ$sp();
                    if (!bl) {
                        ((ListBuffer)nameDoc$2.elem).$plus$eq(nameElementSimilarityDb$.MODULE$.getMatchList((String)element._1(), this.similarityConfig().nameElementSimilarityForHit()).mkString(" "));
                        String string2 = Predef$.MODULE$.augmentString((String)element._1());
                        return ((ListBuffer)nameDoc$2.elem).$plus$eq(StringOps$.MODULE$.sliding$extension(string2, 3, StringOps$.MODULE$.sliding$default$2$extension(string2)).toList().mkString(" "));
                    }
                    if (bl) {
                        return BoxedUnit.UNIT;
                    }
                }
                throw new MatchError(tuple2);
            }
            return ((ListBuffer)nameDoc$2.elem).$plus$eq(element._1());
        }));
        doc.add(new TextField("doc", ((ListBuffer)nameDoc.elem).mkString(" "), Field.Store.NO));
        doc.add(new StringField("json", jsonName, Field.Store.YES));
        Object csList = ((List)countries.map((Function1<String, String> & Serializable)c -> {
            Tuple2<Object, String> tuple2 = Countries$.MODULE$.toIsoCountry(TextNormalizer$.MODULE$.normalize((String)c));
            if (tuple2 != null) {
                boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
                String string2 = tuple2._2();
                if (bl) {
                    String x = string2;
                    return x;
                }
                if (!bl) {
                    String x = string2;
                    return " ";
                }
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, Boolean> & Serializable)_$1 -> {
            String string2 = _$1;
            String string3 = " ";
            return string2 == null ? string3 != null : !string2.equals(string3);
        });
        int n = ((List)csList).length();
        if (0 == n) {
            doc.add(new TextField("cs", "xx", Field.Store.NO));
        } else {
            doc.add(new TextField("cs", ((AbstractIterable)csList).mkString(" "), Field.Store.YES));
        }
        Object ysList = ((List)dates.map((Function1<String, String> & Serializable)y -> {
            NormalizedDate nd = DateNormalizer$.MODULE$.normalizeDate((String)y);
            byte by = nd.dateType();
            if (99 == by) {
                return " ";
            }
            return BoxesRunTime.boxToInteger(nd.year()).toString();
        })).filter((Function1<String, Boolean> & Serializable)_$2 -> {
            String string2 = _$2;
            String string3 = " ";
            return string2 == null ? string3 != null : !string2.equals(string3);
        });
        int n2 = ((List)ysList).length();
        if (0 == n2) {
            doc.add(new TextField("ys", "9999", Field.Store.NO));
        } else {
            doc.add(new TextField("ys", ((AbstractIterable)ysList).mkString(" "), Field.Store.NO));
        }
        doc.add(new StringField("l", label, Field.Store.YES));
        doc.add(new StringField("t", nameType, Field.Store.YES));
        return doc;
    }
}

